---
generated_at: 2026-01-22 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：54-Apache プロバイダー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Provider.Apache.pas` - Apache プロバイダー実装（Delphi版、109行）
- E-02: `src/Horse.Provider.FPC.Apache.pas` - Apache プロバイダー実装（FPC版、132行）
- E-03: `src/Horse.Provider.Abstract.pas` - 抽象プロバイダー（77行）
- E-04: `src/Horse.WebModule.pas` - WebModule実装（118行）
- E-05: `src/Horse.pas` - メインユニット（117行）
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` - 画面マッピング
- E-07: `samples/lazarus/apache/Apache.pas` - Lazarusサンプル

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HORSE_APACHE コンパイルディレクティブで有効化（Delphi） | E-01: 5行目 `{$IF DEFINED(HORSE_APACHE) AND NOT DEFINED(FPC)}` | ○ |
| C-02 | HORSE_APACHE コンパイルディレクティブで有効化（FPC） | E-02: 9行目 `{$IF DEFINED(HORSE_APACHE) AND DEFINED(FPC)}` | ○ |
| C-03 | Web.HTTPD24Impl を使用（Delphi版） | E-01: 9行目 | ○ |
| C-04 | fpApache24 を使用（FPC版） | E-02: 17行目 | ○ |
| C-05 | CoInitFlags = COINIT_MULTITHREADED（Windows） | E-01: 49行目 | ○ |
| C-06 | InitApplication 呼び出し（Delphi版） | E-01: 51行目 | ○ |
| C-07 | MaxConnections設定可能 | E-01: 55-58行目 | ○ |
| C-08 | HandlerName プロパティ | E-01: 21-22行目, 87-95行目 | ○ |
| C-09 | ModuleName プロパティ（FPC版） | E-02: 29行目, 73-81行目 | ○ |
| C-10 | DefaultModule プロパティ | E-01: 23-24行目, E-02: 30行目 | ○ |
| C-11 | SetModuleRecord 呼び出し（FPC版） | E-02: 96行目 | ○ |
| C-12 | AllowDefaultModule = True（FPC版） | E-02: 97行目 | ○ |
| C-13 | OnGetModule イベント設定（FPC版） | E-02: 98行目, 104-107行目 | ○ |
| C-14 | LegacyRouting = True（FPC版） | E-02: 99行目 | ○ |
| C-15 | cthreads ユニット必要（Unix/FPC） | E-02: 11-13行目 `{$IFDEF unix} cthreads` | ○ |
| C-16 | StopListen 機能なし | E-01, E-02: StopListen メソッドの実装なし | ○ |
| C-17 | THorseProviderAbstract を継承 | E-01: 12行目, E-02: 25行目 | ○ |
| C-18 | Webモジュールとの関連 | E-06: 画面No.7とのマッピング | ○ |

## 4) 不足情報（Unknown / Missing）
- なし - 全ての主張に対してソースコードの根拠が確認された

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Delphi版とFPC版の実装差異が正しく記述されているか
- [ ] HandlerName/ModuleName/DefaultModuleの設定方法が正しく説明されているか
- [ ] Unix環境でのcthreads要件が明記されているか
- [ ] Apache 2.4互換である点が明記されているか
